use crate::input::*;

mod ark_an;
mod avf;
mod azmov;
mod crh;
mod dpeg;
mod duck_uqm;
mod guilty;
mod jam;
mod lotr_av;
mod mh_fmv;
mod mux;
mod nl_fmv;
mod nxl;
mod ph;
mod pmv;
mod umv;
mod vdo;
mod vpx1;
mod xanth;

/// The list of all compiled input plugins
pub const INPUT_PLUGINS: &[InputPlugin] = &[
    InputPlugin { name: "ark-an", long_name: "Ark of Time animation", open: ark_an::open },
    InputPlugin { name: "avf", long_name: "American Laser Games / Her Interactive Video", open: avf::open },
    InputPlugin { name: "azmov", long_name: "Azrael's Tear MOV", open: azmov::open },
    InputPlugin { name: "crh-de", long_name: "Dark Earth CRH", open: crh::open_darkearth },
    InputPlugin { name: "crh-nc", long_name: "Nightmare Creatures CRH", open: crh::open_creatures },
    InputPlugin { name: "dpeg", long_name: "DPEG", open: dpeg::open },
    InputPlugin { name: "duck-uqm", long_name: "TrueMotion video for 3DO version of SC2", open: duck_uqm::open },
    InputPlugin { name: "guilty", long_name: "Innocent Until Caught 1/2 cutscenes", open: guilty::open },
    InputPlugin { name: "jam", long_name: "JAM video", open: jam::open },
    InputPlugin { name: "lotr-av", long_name: "Lord of the Rings AV", open: lotr_av::open },
    InputPlugin { name: "mh-fmv", long_name: "Machine Hunter FMV", open: mh_fmv::open },
    InputPlugin { name: "mux", long_name: "Infogrames MUX video", open: mux::open },
    InputPlugin { name: "nl-fmv", long_name: "Nightlong FMV (320x180)", open: nl_fmv::open1 },
    InputPlugin { name: "nl-fmv2", long_name: "Nightlong FMV2 (640x360)", open: nl_fmv::open2 },
    InputPlugin { name: "nxl", long_name: "The Lawnmower Man NXL", open: nxl::open },
    InputPlugin { name: "ph", long_name: "Total Multimedia PH video", open: ph::open },
    InputPlugin { name: "pmv", long_name: "Infocom PMV", open: pmv::open },
    InputPlugin { name: "umv-afraid", long_name: "Are You Afraid of the Dark UMV", open: umv::open_afraid },
    InputPlugin { name: "umv-dracula", long_name: "Dracula Unleashed UMV", open: umv::open_dracula },
    InputPlugin { name: "vdo", long_name: "Harrow Media VDO", open: vdo::open },
    InputPlugin { name: "vpx1", long_name: "reLINE VPX1", open: vpx1::open },
    InputPlugin { name: "xanth", long_name: "Companions of Xanth cutscenes", open: xanth::open },
];
