use crate::output::*;

struct NullWriter {}

impl OutputWriter for NullWriter {
    fn add_stream(&mut self, _stream_no: usize, _stream_info: StreamInfo) -> EncoderResult<()> { Ok(()) }
    fn finish_header(&mut self) -> EncoderResult<()> { Ok(()) }
    fn write(&mut self, _stream_no: usize, _frame: Frame) -> EncoderResult<()> { Ok(()) }
    fn finish(&mut self) -> EncoderResult<()> { Ok(()) }
}

pub fn create(_name: &str) -> EncoderResult<Box<dyn OutputWriter>> {
    Ok(Box::new(NullWriter{}))
}
