# Supported Formats

Format name | Description | Notes
----------- | ----------- | -----
`ace` | Space Ace PC port scenes | Decoding is incorrect but sometimes video is recognizable
`acf` | Time Commando ACF |
`ai_cda` | Alien Incident CDA | Fading is not completely correct
`ark_an` | Ark of Time animation |
`ascon` | Asc(ar)on animation format | Used at least in `Elisabeth I`/`Gloriana` game
`avf` | American Laser Games / Her Interactive animation | Older format used in e.g. "Vampire Diaries" has an external palette stored in BMP files. So if such file is renamed to `avf-old-pal.bmp` it will be read and the palette from it will be applied to the output.
`avx` | Jack Orlando video |
`azmov` | Azrael's Tear MOV |
`bal` | Baldies animation | Used in older DOS version of the game (newer PC versions use FLI instead)
`bd13` | Brain Dead 13 PC port scenes | All videos are stored inside `BD.DAT`
`ca2` | Microcosm CA2 |
`cda` | Pray for Death CDA |
`ci2` | Arxel Tribe CI2 | Used in several of their games like _Casanova_ or _Faust_.
`cnm` | Arxel Tribe CNM | Used in _Ring: The Legend of the Nibelungen_.
`crh-de` | Dark Earth CRH |
`crh-nc` | Nightmare Creatures CRH | The format is almost the same as `crh-de` but codes 320x240 frames using a bitstream format using one extra bit in a certain place.
`cyclemania` | Cyclemania video | Requires several files (with `.col`, `.hed`, `.frm` and `.vid` extensions), either one of those or the base name (i.e. without extension) should be provided.
`cydonia` | Cydonia Paco | Not to be confused with PACo format used e.g. in _Iron Helix_
`defcon5` | Defcon 5 .vid | Most game versions use Smacker instead
`derf-aud` | Xilam DERF | Audio format used in _Stupid Invaders_ game
`derf-vid` | Xilam DERF | Video format used in _Stupid Invaders_ game
`dkanim` | Dorling Kindersley animation | Animation requires an accompanying `.dib` file to be decoded properly.
`dpeg` | DPEG | The format is used in _Bloodwings: Pumpkinhead's Revenge_
`drl` | Thunder In Paradise (PC port) DRL |
`duck-uqm` | TrueMotion video used in 3DO version of _Star Control II_ | Requires several files (with `.duk`, `.hdr`, `.frm` and `.tbl` extensions), either one of those or the base name (i.e. without extension) should be provided.
`etv` | Hercules ETV |
`fcmp` | FutureVision audio format | Used in _Harvester_ game
`fla` | Little Big Adventure FLA |
`flh` | Conquest Earth FLH | Often found inside `.wad` archives
`fli` | FLIC | Includes some game-specific variations
`fst` | FutureVision video format | Used in _Harvester_ game
`guilty` | Innocent Until Caught 1/2 cutscenes | Files are named `IUC_F??.DAT` and `GBG_F??.DAT` respectively.
`h2o` | The Pandora Directive H2O | Videos are stored unnamed inside `.ap` archives
`haf` | Death Rally HAF |
`hl-fmv` | Cutscene format from _Highlander: The Last of the MacLeods_ unpublished game |
`imx` | Fable video | This means a game from 1996 by Simbiosis Interactive
`jam` | JAM video | Used in various games
`jazz2` | Jazz Jackrabbit 2 cutscene |
`kdv-af` | Nova Logic video | Videos from _Armored Fist_
`kdv-c` | Nova Logic video | Videos from _Comanche: Maximum Overkill_
`kdv-cg` | Nova Logic video | Video from _Comanche Gold_
`kdv-wc` | Nova Logic video | Videos from _Werewolf vs. Comanche_
`kdv24` | Nova Logic video | 24-bit videos from newer games
`lair` | Dragon's Lair PC port scenes |
`lotr-av` | Lord of the Rings AV |
`mh-fmv` | Machine Hunter FMV |
`mux` | MUX | Format used in various Infogrames games. _Chaos Control_ has some videos with unsupported coding mode.
`nl-fmv` | Nightlong FMV | 320x180 videos used in Amiga version of the game
`nl-fmv2` | Nightlong FMV2 | 640x360 videos used in Amiga version of the game
`nxl` | The Lawnmower Man NXL |
`origin-fli` | Origin hybrid of FLI and IFF | Used in _Ultima VII_ games intro/ending. Speed changes and audio part are not supported.
`origin-ssm` | System Shock movie/audio format | Videos are stored unnamed inside `.res` archives
`paco` | PACo video | Video format used e.g. in _Hell Cab_ or _Iron Helix_ (not to be confused with Cydonia Paco)
`ph` | Total Multimedia PH video | Video format used in some interactive multimedia CD-ROMs
`pmv` | Infocom movie format used in _Return to Zork_ and some demos |
`psy-str` | Psychic Detective STR |
`ptf` | Under a Killing Moon PTF | Videos are stored unnamed inside `.ap` archives
`q` | Legend Entertainment Q | Used in various games by this company
`qrac-fmv` | Network Q RAC Rally FMV |
`ratvid` | Ratvideo or VIDPAK | Used in several EA games
`raven-anm` | Ravenloft ANM |
`rbt` | Sierra robot format | Used in later Sierra games usually for large sprite animations
`rlf` | Sprite format used in some Zork games |
`sdv` | Stardock video | Used in _Stardock: Entrepreneur_ multiplayer game
`siff` | Beam Software SIFF | Used in various games by this company, often found in `.gob` archives
`soulhunt` | Soul Hunt VID | JPEG compression is not supported
`talisman` | Talisman Animation | Some files are not decoded correctly
`tvi` | Terminal Velocity video | It requires global palette `vga.act` stored in `startup.pod` (but may work without it)
`umv-afraid` | Are You Afraid of the Dark UMV |
`umv-dracula` | Dracula Unleashed UMV | Those two formats are the same but `umv-afraid` uses signed 8-bit audio instead of unsigned.
`vdo` | Harrow Media VDO | Used in _The Fuel Run_ game
`vpx1` | reLINE VPX1 | Used in _BIING!_ game
`vx` | Actimagine VX | Used in many games for a certain portable console
`wingnuts` | Wing Nuts video frames | Since files are actually a complex engine data, only video frames are extracted.
`xanth` | Companions of Xanth cutscenes | Cutscenes are stored in files `XANTH_91.PIC`..`XANTH_99.PIC`. Other `.PIC` files from Legent Entertainment games may be extracted (best to image sequence) with some degree of success.
`yo-mxv` | Yo Matias game cutscenes and music | Newer MXV versions with Vorbis audio are not supported
`yumimi-ablk` | Yumimi Mix animations | Only individual sprites are decoded, colours may be wrong too.
`yumimi-cut` | Yumimi Mix animations | Decoding is incomplete and timings are often wrong
`zorton` | Zorton Brothers video | PC port is also known as _Los Justicieros_
