use crate::input::*;

mod ace;
mod acf;
mod ai_cda;
mod ark_an;
mod ascon;
mod avf;
mod avx;
mod azmov;
mod bal;
mod bd13;
mod ca2;
mod cda;
mod ci2;
mod cnm;
mod crh;
mod cyclemania;
mod cydonia;
mod derf;
mod defcon5;
mod dkanim;
mod dpeg;
mod drl;
mod duck_uqm;
mod etv;
mod fla;
mod fli;
mod fv;
mod guilty;
mod h2o;
mod haf;
mod hl_fmv;
mod imax;
mod jam;
mod jazz2;
mod kdv;
mod kdv_c;
mod lair;
mod lotr_av;
mod mh_fmv;
mod mux;
mod nl_fmv;
mod nxl;
mod paco;
mod ph;
mod pmv;
mod psy_str;
mod q;
mod qrac;
mod ratvid;
mod raven;
mod rbt;
mod rlf;
mod sdv;
mod siff;
mod soulhunt;
mod ssm;
mod talis_ani;
mod tvi;
mod umv;
mod vdo;
mod vpx1;
mod vx;
mod wingnuts;
mod xanth;
mod yo_mxv;
mod yumimi;
mod zorton;

/// The list of all compiled input plugins
pub const INPUT_PLUGINS: &[InputPlugin] = &[
    InputPlugin { name: "ace", long_name: "Space Ace scenes", open: ace::open },
    InputPlugin { name: "acf", long_name: "Time Commando ACF", open: acf::open },
    InputPlugin { name: "ai_cda", long_name: "Alien Incident CDA", open: ai_cda::open },
    InputPlugin { name: "ark-an", long_name: "Ark of Time animation", open: ark_an::open },
    InputPlugin { name: "ascon", long_name: "Asc(ar)on animation", open: ascon::open },
    InputPlugin { name: "avf", long_name: "American Laser Games / Her Interactive Video", open: avf::open },
    InputPlugin { name: "avx", long_name: "Jack Orlando AVX", open: avx::open },
    InputPlugin { name: "azmov", long_name: "Azrael's Tear MOV", open: azmov::open },
    InputPlugin { name: "bal", long_name: "Baldies animation", open: bal::open },
    InputPlugin { name: "bd13", long_name: "Brain Dead 13 scenes", open: bd13::open },
    InputPlugin { name: "ca2", long_name: "Microcosm CA2", open: ca2::open },
    InputPlugin { name: "cda", long_name: "Pray for Death CDA", open: cda::open },
    InputPlugin { name: "ci2", long_name: "Arxel Tribe CI2", open: ci2::open },
    InputPlugin { name: "cnm", long_name: "Arxel Tribe CNM", open: cnm::open },
    InputPlugin { name: "crh-de", long_name: "Dark Earth CRH", open: crh::open_darkearth },
    InputPlugin { name: "crh-nc", long_name: "Nightmare Creatures CRH", open: crh::open_creatures },
    InputPlugin { name: "cyclemania", long_name: "Cyclemania video", open: cyclemania::open },
    InputPlugin { name: "cydonia", long_name: "Cydonia Paco", open: cydonia::open },
    InputPlugin { name: "defcon5", long_name: "Defcon 5 video", open: defcon5::open },
    InputPlugin { name: "derf-aud", long_name: "Xilam DERF audio", open: derf::open_audio },
    InputPlugin { name: "derf-vid", long_name: "Xilam DERF video", open: derf::open_video },
    InputPlugin { name: "dkanim", long_name: "DK animation", open: dkanim::open },
    InputPlugin { name: "dpeg", long_name: "DPEG", open: dpeg::open },
    InputPlugin { name: "drl", long_name: "Thunder In Paradise DRL", open: drl::open },
    InputPlugin { name: "duck-uqm", long_name: "TrueMotion video for 3DO version of SC2", open: duck_uqm::open },
    InputPlugin { name: "etv", long_name: "Hercules ETV", open: etv::open },
    InputPlugin { name: "fcmp", long_name: "FutureVision audio", open: fv::open_audio },
    InputPlugin { name: "fla", long_name: "Little Big Adventure FLA", open: fla::open },
    InputPlugin { name: "flh", long_name: "Conquest Earth FLH", open: fli::open_flh },
    InputPlugin { name: "fli", long_name: "FLIC", open: fli::open_fli },
    InputPlugin { name: "fst", long_name: "FutureVision video", open: fv::open_video },
    InputPlugin { name: "guilty", long_name: "Innocent Until Caught 1/2 cutscenes", open: guilty::open },
    InputPlugin { name: "h2o", long_name: "The Pandora Directive video", open: h2o::open },
    InputPlugin { name: "haf", long_name: "Death Rally HAF", open: haf::open },
    InputPlugin { name: "hl-fmv", long_name: "Highlander cutscenes", open: hl_fmv::open },
    InputPlugin { name: "imx", long_name: "Fable video", open: imax::open },
    InputPlugin { name: "jam", long_name: "JAM video", open: jam::open },
    InputPlugin { name: "jazz2", long_name: "Jazz Jackrabbit 2 cutscene", open: jazz2::open },
    InputPlugin { name: "kdv24", long_name: "Comanche video", open: kdv::open_24 },
    InputPlugin { name: "kdv-c", long_name: "Comanche video", open: kdv_c::open },
    InputPlugin { name: "kdv-af", long_name: "Armored Fist video", open: kdv::open_af },
    InputPlugin { name: "kdv-cg", long_name: "Comanche Gold video", open: kdv::open_cg },
    InputPlugin { name: "kdv-wc", long_name: "Werewolf vs. Comanche video", open: kdv::open_wc },
    InputPlugin { name: "lair", long_name: "Dragon's Lair PC port scene", open: lair::open },
    InputPlugin { name: "lotr-av", long_name: "Lord of the Rings AV", open: lotr_av::open },
    InputPlugin { name: "mh-fmv", long_name: "Machine Hunter FMV", open: mh_fmv::open },
    InputPlugin { name: "mux", long_name: "Infogrames MUX video", open: mux::open },
    InputPlugin { name: "nl-fmv", long_name: "Nightlong FMV (320x180)", open: nl_fmv::open1 },
    InputPlugin { name: "nl-fmv2", long_name: "Nightlong FMV2 (640x360)", open: nl_fmv::open2 },
    InputPlugin { name: "nxl", long_name: "The Lawnmower Man NXL", open: nxl::open },
    InputPlugin { name: "origin-fli", long_name: "Origin IFF FLI", open: fli::open_origin },
    InputPlugin { name: "origin-ssm", long_name: "System Shock movie", open: ssm::open },
    InputPlugin { name: "paco", long_name: "PACo", open: paco::open },
    InputPlugin { name: "ph", long_name: "Total Multimedia PH video", open: ph::open },
    InputPlugin { name: "pmv", long_name: "Infocom PMV", open: pmv::open },
    InputPlugin { name: "psy-str", long_name: "Psychic Detective STR", open: psy_str::open },
    InputPlugin { name: "ptf", long_name: "Under a Killing Moon PTF", open: fli::open_ptf },
    InputPlugin { name: "q", long_name: "Legend Entertainment Q", open: q::open },
    InputPlugin { name: "qrac-fmv", long_name: "Network Q RAC Rally FMV", open: qrac::open },
    InputPlugin { name: "ratvid", long_name: "Ratvideo", open: ratvid::open },
    InputPlugin { name: "raven-anm", long_name: "Ravenloft ANM", open: raven::open },
    InputPlugin { name: "rbt", long_name: "Sierra robot", open: rbt::open },
    InputPlugin { name: "rlf", long_name: "Zork RLF", open: rlf::open },
    InputPlugin { name: "sdv", long_name: "Stardock video", open: sdv::open },
    InputPlugin { name: "siff", long_name: "Beam Software SIFF", open: siff::open },
    InputPlugin { name: "soulhunt", long_name: "Soul Hunt VID", open: soulhunt::open },
    InputPlugin { name: "talisman", long_name: "Talisman animation", open: talis_ani::open },
    InputPlugin { name: "tvi", long_name: "Terminal Velocity video", open: tvi::open },
    InputPlugin { name: "umv-afraid", long_name: "Are You Afraid of the Dark UMV", open: umv::open_afraid },
    InputPlugin { name: "umv-dracula", long_name: "Dracula Unleashed UMV", open: umv::open_dracula },
    InputPlugin { name: "vdo", long_name: "Harrow Media VDO", open: vdo::open },
    InputPlugin { name: "vpx1", long_name: "reLINE VPX1", open: vpx1::open },
    InputPlugin { name: "vx", long_name: "Actimagine VX", open: vx::open },
    InputPlugin { name: "wingnuts", long_name: "Wing Nuts game videos", open: wingnuts::open },
    InputPlugin { name: "xanth", long_name: "Companions of Xanth cutscenes", open: xanth::open },
    InputPlugin { name: "yo-mxv", long_name: "Yo Matias videos and music", open: yo_mxv::open },
    InputPlugin { name: "yumimi-ablk", long_name: "Yumimi Mix animations (ABLK)", open: yumimi::open_ablk },
    InputPlugin { name: "yumimi-cut", long_name: "Yumimi Mix animations (ACUT)", open: yumimi::open_cut },
    InputPlugin { name: "zorton", long_name: "Zorton Brothers video", open: zorton::open },
];
